﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace MenuAddCheckBox
{
    public class ToolStripCheckBoxMenuItem : ToolStripControlHost
    {
        public ToolStripCheckBoxMenuItem(string str)
            : base(new CheckBox(), str)
        {
            this.Control.Text = str;
        }
        public string TxtName
        {
            get { return (Control as CheckBox).Text; }
            set { (Control as CheckBox).Text = value; }
        }
        public CheckBox CheckBoxControl
        {
            get { return Control as CheckBox; }
        }
        public CheckState checkState
        {
            get { return ((CheckBox)this.Control).CheckState; }
            set { ((CheckBox)this.Control).CheckState = value; }
        }
        protected override void OnSubscribeControlEvents(Control c)
        {
            base.OnSubscribeControlEvents(c);
            CheckBox checkBox = (CheckBox)c;
            checkBox.CheckStateChanged += new EventHandler(checkBox_CheckStateChanged);
        }
        
       
        
        
        public static ContextMenuStrip newMenuStrip()
        {
            ContextMenuStrip ContxtmnStrip = new ContextMenuStrip();
            ToolStripCheckBoxMenuItem Compiled = new ToolStripCheckBoxMenuItem("Compiled");
            ToolStripCheckBoxMenuItem CultureInvariant = new ToolStripCheckBoxMenuItem("CultureInvariant");
            ToolStripCheckBoxMenuItem ECMAScript = new ToolStripCheckBoxMenuItem("ECMAScript");
            ToolStripCheckBoxMenuItem ExplicitCapture = new ToolStripCheckBoxMenuItem("ExplicitCapture");
            ToolStripCheckBoxMenuItem IgnoreCase = new ToolStripCheckBoxMenuItem("IgnoreCase");
            ToolStripCheckBoxMenuItem IgnorePatternWhitespace = new ToolStripCheckBoxMenuItem("IgnorePatternWhitespace");
            ToolStripCheckBoxMenuItem Multiline = new ToolStripCheckBoxMenuItem("Multiline");
            ToolStripCheckBoxMenuItem RightToLeft = new ToolStripCheckBoxMenuItem("RightToLeft");
            ToolStripCheckBoxMenuItem Singleline = new ToolStripCheckBoxMenuItem("Singleline");
            
            ContxtmnStrip.Items.AddRange(new ToolStripItem[]{Compiled,CultureInvariant,ECMAScript,
                ExplicitCapture,IgnoreCase,IgnorePatternWhitespace,Multiline,RightToLeft,Singleline});
            return ContxtmnStrip;
        }
        void checkBox_CheckStateChanged(object sender, EventArgs e)
        {
            Invalidate();
            if (CheckChanged != null)
            {
                CheckChanged(this, e);
            }

        }
        public event EventHandler CheckChanged;
      

    }
}
